/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.SliderButton;
import net.minecraft.client.gui.components.VolumeSlider;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;

public abstract class AdditionalVolumeSlider
extends AbstractClientTweak {
    private final SoundSource soundSource;
    private final int offsetX;

    public AdditionalVolumeSlider(String name, SoundSource soundSource, int offsetX) {
        super(name);
        this.soundSource = soundSource;
        this.offsetX = offsetX;
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, this::onInitGui);
    }

    public void onInitGui(ScreenInitEvent.Post event) {
        if (this.isEnabled() && event.getScreen() instanceof OptionsScreen) {
            int x = 0;
            int y = 0;
            for (GuiEventListener widget : ((ScreenAccessor)event.getScreen()).balm_getChildren()) {
                if (!(widget instanceof SliderButton)) continue;
                SliderButton slider = (SliderButton)widget;
                x = slider.f_93620_;
                y = slider.f_93621_;
            }
            VolumeSlider slider = new VolumeSlider(Minecraft.m_91087_(), x + this.offsetX, y + 27, this.soundSource, 150);
            slider.m_93666_(this.getSliderDisplayString());
            BalmClient.getScreens().addRenderableWidget(event.getScreen(), (AbstractWidget)slider);
        }
    }

    private Component getSliderDisplayString() {
        float volume = Minecraft.m_91087_().f_91066_.m_92147_(this.soundSource);
        Object displayVolume = volume == 0.0f ? I18n.m_118938_((String)"options.off", (Object[])new Object[0]) : (int)(volume * 100.0f) + "%";
        TranslatableComponent volumeText = new TranslatableComponent("soundCategory." + this.soundSource.m_12676_());
        volumeText.m_7220_((Component)new TextComponent(": " + (String)displayVolume));
        return volumeText;
    }
}

